<?php
/**
 * User Tag
 *
 * @package     AutomatorWP\Integrations\WP_Fusion\Actions\User_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_Fusion_User_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'wp_fusion';
    public $action = 'wp_fusion_user_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add or remove tag to user', 'automatorwp-pro' ),
            'select_option'     => __( 'Add or remove <strong>tag</strong> to user', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. */
            'edit_label'        => sprintf( __( '%1$s tag %2$s', 'automatorwp-pro' ), '{operation}', '{tag}' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. */
            'log_label'         => sprintf( __( '%1$s tag %2$s', 'automatorwp-pro' ), '{operation}', '{tag}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'add'       => __( 'Add', 'automatorwp-pro' ),
                                'remove'    => __( 'Remove', 'automatorwp-pro' ),
                            ),
                            'default' => 'add'
                        ),
                    )
                ),
                'tag' => array(
                    'from' => 'tag',
                    'default' => __( 'Select a tag', 'automatorwp-pro' ),
                    'fields' => array(
                        'tag' => array(
                            'name' => __( 'Tag:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options_cb' => array( $this, 'options_cb_tags' ),
                            'default' => ''
                        )
                    )
                )
            ),
        ) );

    }

    /**
     * Options callback for tags options
     *
     * @since 1.0.0
     *
     * @param stdClass $field
     *
     * @return array
     */
    public function options_cb_tags( $field ) {

        $options = array();

        $tags = wp_fusion()->settings->get( 'available_tags' );

        if( is_array( $tags ) ) {
            $options = array_merge( $options, $tags );
        }

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $tag = $action_options['tag'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'add';
        }

        // Bail if empty tag to assign
        if( empty( $tag ) ) {
            return;
        }

        // Get the tag ID
        $tag_id = wp_fusion()->user->get_tag_id( $tag );

        // Bail if tag doesn't exists
        if( $tag_id === false ) {
            return;
        }

        // Get contact ID
        $contact_id = wp_fusion()->user->get_contact_id( $user_id, true );

        // If user not registered then register him
        if ( $contact_id === false) {
            wp_fusion()->user->user_register( $user_id );
        }

        $user_tags = wp_fusion()->user->get_tags( $user_id );

        switch ( $operation ) {
            case 'add':
                // If tag isn't already applied then apply it
                if ( ! in_array( $tag_id, $user_tags, true ) ) {
                    wp_fusion()->user->apply_tags( array( $tag_id ), $user_id );
                }
                break;
            case 'remove':
                // If tag is already applied then remove it
                if ( in_array( $tag_id, $user_tags, true ) ) {
                    wp_fusion()->user->remove_tags( array( $tag_id ), $user_id );
                }
                break;
        }


    }

}

new AutomatorWP_WP_Fusion_User_Tag();